#include <bits/stdc++.h>
#define ll long long
#define MAXN 100010
using namespace std;
ll n,s,a[MAXN];
struct element
{
    ll minn=LLONG_MAX,maxx=LLONG_MIN;
};
element neutral_element;
struct seg_tree
{
    vector<element> st;
    element Merge(element x,element y)
    {
        return {min(x.minn,y.minn),max(x.maxx,y.maxx)};
    }
    void Init()
    {
        s=1;
        while (s<n)
            s <<= 1;
        st.resize(2*s+2);
    }
    void Add(ll pos,element val,ll x,ll lx,ll rx)
    {
        if (lx>pos || rx<pos)
            return;
        if (lx==rx)
        {
            st[x]=val;
            return;
        }
        ll mid=(lx+rx)/2;
        if (pos<=mid)
            Add(pos,val,2*x,lx,mid);
        else
            Add(pos,val,2*x+1,mid+1,rx);
        st[x]=Merge(st[2*x],st[2*x+1]);
    }
    element Calc(ll l,ll r,ll x,ll lx,ll rx)
    {
        if (lx>r || rx<l)
            return neutral_element;
        if (lx>=l && rx<=r)
            return st[x];
        ll mid=(lx+rx)/2;
        return Merge(Calc(l,r,2*x,lx,mid),Calc(l,r,2*x+1,mid+1,rx));
    }
};
seg_tree S[21][2];
int main()
{
    ios::sync_with_stdio(false); cin.tie(0); cout.tie(0);
    cin >> n;
    for (ll i=0;i<21;i++)
    {
        for (ll j=0;j<2;j++)
            S[i][j].Init();
    }
    ll cnt=0;
    for (ll i=1;i<=n;i++)
    {
        cin >> a[i];
        for (ll j=0;j<20;j++)
        {
            if ((1ll<<j)&a[i])
                S[j][1].Add(i,{i,i},1,1,s);
            else
                S[j][0].Add(i,{i,i},1,1,s);
        }
    }
    ll q,t,x,y;
    cin >> q;
    while (q--)
    {
        cin >> t >> x;
        if (t==1)
        {
            cin >> y;
            for (ll j=0;j<20;j++)
            {
                if ((1ll<<j)&a[x])
                    S[j][1].Add(x,neutral_element,1,1,s);
                else
                    S[j][0].Add(x,neutral_element,1,1,s);
            }
            a[x]=y;
            for (ll j=0;j<20;j++)
            {
                if ((1ll<<j)&a[x])
                    S[j][1].Add(x,{x,x},1,1,s);
                else
                    S[j][0].Add(x,{x,x},1,1,s);
            }
            continue;
        }
        vector<pair<ll,ll> > pos;
        for (ll j=0;j<20;j++)
        {
            if ((1ll<<j)&a[x])
            {
                pair<ll,ll> t={-1,-1};
                element ans=S[j][0].Calc(1,x,1,1,s);
                t.first=ans.maxx;
                ans=S[j][0].Calc(x,n,1,1,s);
                t.second=ans.minn;
                pos.push_back(t);
            }
        }
        if (!pos.size())
        {
            cout << 0 << "\n";
            continue;
        }
        ll res=LLONG_MAX;
        for (ll j=0;j<pos.size();j++)
        {
            if (pos[j].first==LLONG_MIN)
                continue;
            ll l=pos[j].first,r=x;
            bool check=true;
            for (ll i=0;i<pos.size();i++)
            {
                if (pos[i].first>=l)
                    continue;
                if (pos[i].second==LLONG_MAX)
                    check=false;
                else
                    r=max(r,pos[i].second);
            }
            if (check)
                res=min(res,r-l+min(x-l,r-x));
        }
        ll l=x,r=x;
        bool check=true;
        for (ll i=0;i<pos.size();i++)
        {
            if (pos[i].second==LLONG_MAX)
                check=false;
            else
                r=max(r,pos[i].second);
        }
        if (check)
            res=min(res,r-l+min(x-l,r-x));
        if (res==LLONG_MAX)
            cout << -1 << "\n";
        else
            cout << res << "\n";
    }
    return 0;
}
/**
7
7 2 2 7 5 4 4
1
2 4
**/